'use strict';

angular.module('genisis').controller('requestHistoryCtrl', ['$scope', 'request',
  '$rootScope', 'api', 'user', '$routeParams', '$location',
  function ($scope, $requests, $rootScope, $api, $user, $routeParams,
    $location) {
    $scope.requests = $requests;
    $scope.request = {};
    $scope.logs = [];

    $scope.load = function (requestID) {
      //load the logs for this request
      $requests.logs(requestID).then(function (logData) {
        $scope.logs = $requests.parseLogs(logData);
      });

      $requests.findByID(requestID).then(function (request) {
        $scope.request = request;
      });
    };

    $scope.backToRequest = function () {
      $location.path('/requests/' + $routeParams.id);
      return true;
    };

    $scope.load($routeParams.id);
  }
]);